<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

if (!is_object($vbulletin->db))
{
	exit;
}

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

if (defined('IN_CONTROL_PANEL'))
{
	define('ECHO_CRON_LOG', true);
}

do
{
	if (!$vbulletin->options['dbtech_vbmail_inactive_enabled'])
	{
		// Not enabled
		break;
	}

	if (!$vbulletin->options['dbtech_vbmail_inactive_perbatch'])
	{
		// We need at least 1 user
		break;
	}

	// Make sure this is an array
	$usergroupids = @unserialize($vbulletin->options['dbtech_vbmail_inactive_usergroups']);
	$usergroupids = is_array($usergroupids) ? $usergroupids : array();

	// Get rid of this
	unset($usergroupids[0]);

	if (!count($usergroupids))
	{
		// We had no included usergroups
		break;
	}

	// Fire ze mailqueue
	vbmail_start();

	$reminders = array();
	$users = $vbulletin->db->query_read_slave("
		SELECT *
		FROM `" . TABLE_PREFIX . "user`
		WHERE (
				FIND_IN_SET(" . implode(', membergroupids) OR FIND_IN_SET(', $usergroupids) . ", membergroupids)
				OR usergroupid IN(" . implode(',', $usergroupids) . ")
			)
			AND dbtech_vbmail_bounceflag = '0'
			AND " . $vbulletin->options['dbtech_vbmail_inactive_metric'] . " <= " . (TIMENOW - ($vbulletin->options['dbtech_vbmail_inactive_threshold'] * 86400)) . "
			AND dbtech_vbmail_inactivereminder <= " . (TIMENOW - ($vbulletin->options['dbtech_vbmail_inactive_threshold'] * 86400)) . "
			" . ($vbulletin->options['dbtech_vbmail_inactive_repetitions'] ? ("AND dbtech_vbmail_numreminders < " . $vbulletin->options['dbtech_vbmail_inactive_repetitions']) : '') . "
		LIMIT " . intval($vbulletin->options['dbtech_vbmail_inactive_perbatch']) . "
	");
	while ($user = $vbulletin->db->fetch_array($users))
	{
		if ($user['email'])
		{
			$info = array(
				'username' 		=> $user['username'],
				'bbtitle' 		=> $vbulletin->options['bbtitle'],
				'bburl' 		=> $vbulletin->options['bburl'],
			);

			// Grab our email phrases
			eval(fetch_email_phrases('dbtech_vbmail_inactive_reminder', $user['languageid']));

			if ($show['vbmail_branding'] AND !$show['_dbtech_branding_override'])
			{
				$brandingVariables = array(
					'flavour' 			=> 'Mailing List provided by ',
					'productid' 		=> 107,
					'utm_source' 		=> str_replace('www.', '', htmlspecialchars_uni($_SERVER['HTTP_HOST'])) . ' (email)',
					'utm_content' 		=> (VBMAIL::$isPro ? 'Pro' : 'Lite'),
					'referrerid' 		=> $vbulletin->options['dbtech_vbmail_referral'],
					'title' 			=> 'vBMail',
					'displayversion' 	=> $vbulletin->options['dbtech_vbmail_displayversion'],
					'version' 			=> '2.1.3',
					'producttype' 		=> $show['dbtech_vbmail_producttype']
				);
				$message .= "\n\n" . $brandingVariables['flavour'] . $brandingVariables['title'] . "\nhttp://www.dragonbyte-tech.com/vbecommerce.php" . ($brandingVariables['productid'] ? '?productid=' . $brandingVariables['productid'] . '&do=product&' : '?') . 'utm_source=' . $brandingVariables['utm_source'] . '&utm_campaign=product&utm_medium=' . urlencode(str_replace(' ', '+', $brandingVariables['title'])) . '&utm_content=' . $brandingVariables['utm_content'] . ($brandingVariables['referrerid'] ? '&referrerid=' . $brandingVariables['referrerid'] : '') . "\nCopyright (C) " . date('Y') . ' DragonByte Technologies Ltd.';
			}

			// Queue the email
			vbmail($user['email'], $subject, $message);
		}

		// Update the inactivereminder and numreminders columns
		$vbulletin->db->query_write("
			UPDATE `" . TABLE_PREFIX . "user`
			SET
				dbtech_vbmail_inactivereminder = UNIX_TIMESTAMP(),
				dbtech_vbmail_numreminders = dbtech_vbmail_numreminders + 1
			WHERE userid = $user[userid]
		");

		// Store that this user has been reminded
		$reminders[] = $user['username'];
	}

	// Ze mailqueue ended
	vbmail_end();

	if (count($reminders))
	{
		log_cron_action('Inactive Users Reminded: ' . implode(', ', $reminders), $nextitem);
	}
}
while (false);